﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class LoadOnDblClick : MonoBehaviour {
    public SppMenuData menu;
    public SppModelLoader modelLoader;
    public float doubleClickTime = 0.3f;

    private int id = -1;
    private float lastSelectUpTime;

    void Update () {
        if (Input.GetButtonDown(XRInput.Trigger))
        {
            Debug.Log("Tigger");
            if ((Time.time - lastSelectUpTime) < doubleClickTime)
            {
                Debug.Log("DoubleClick");
                if (menu.onlineItems != null)
                {
                    id += 1;
                    if (id >= menu.onlineItems.Length)
                    {
                        id = 0;
                    }
                    LoadModel();
                }
            }

        }

        if (Input.GetButtonUp(XRInput.Trigger))
        {
            lastSelectUpTime = Time.time;
        }
	}

    private void LoadModel()
    {
        if (modelLoader != null)
        {
            Transform root = modelLoader.transform.Find("000");
            if (root != null)
            {
                GameObject.Destroy(root.gameObject);
            }
            modelLoader.transform.position = Vector3.zero;
            modelLoader.Load(menu.onlineItems[id].url, "/");
        }

    }
}
